/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.FormatText;
import com.ibm.hwmca.base.logd.IssueCmd;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;

public class RetrieveRefcode {
    private static final String TRACE_MASKT = "XLOGDRRT";
    private static final String TRACE_MASKF = "XLOGDRRF";
    private static final String TRACE_MASKD = "XLOGDRRD";
    private static final char NEW_LINE = '\n';
    private static final char END_OF_STRING = '\u0000';
    private Log[] _logData;
    private String _text;
    private static final int REFCODE_LENGTH = 8;
    private static final LocalizableText _lRefcodeDesc = new LocalizableText(BaseTextBundle.getBundleName(), "logd.refcode.title");

    public void getDisplayRefcode(PanelTasklet panelTasklet, EventLogData eventLogData) throws TaskletException, IOException {
        Trace.trace(TRACE_MASKT, "-> RetrieveRefcode.getRefcode()");
        String refcode = eventLogData.getData();
        BaseMessageText myMess = null;
        int refcodeLen = refcode.length();
        if (refcodeLen > 8) {
            refcode = refcode.substring(0, 8);
        }
        String cmd = "bbresrc " + refcode;
        Trace.trace(TRACE_MASKF, "before getRefcodeDescCmd=" + cmd);
        String refcodeDesc = IssueCmd.execute(cmd);
        Trace.trace(TRACE_MASKF, "after getRefcodeDescCmd=" + cmd);
        if (refcodeDesc == null || refcodeDesc.length() == 0) {
            myMess = new BaseMessageText("LOGNREFC");
        } else {
            Object[] subVar = new String[]{FormatText.createText(refcodeDesc)};
            myMess = new BaseMessageText("LOGDREFC", subVar);
        }
        panelTasklet.showMessageBox(true, _lRefcodeDesc, myMess, null, null);
        Trace.trace(TRACE_MASKT, "<- RetrieveRefcode.getRefcode()");
    }
}

